using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

      static bool SignFile(CPDF PDF, String InFileName, String OutFileName, String FieldName, String Reason, double PosX, bool VisibleSignature)
      {
         bool retval = false;
         String filePath = null;
         String outName = OutFileName;
         if (InFileName == OutFileName)
         {
            filePath = Path.GetTempFileName();
            outName  = filePath;
         }
         PDF.CreateNewPDF(outName);

         /*
            Adding multiple signatures with a demo version of DynaPDF couldn't work since a demo string would
            be added to each page that was edited or changed and this would invalidate previous signatures.
         */
         PDF.SetLicenseKey("SigDemo");

         // This flag also sets the flags ifImportAsPage | ifImportAll, and if2UseProxy | if2CopyEncryptDict to make sure that
         // anything is imported and nothing gets changed.
         PDF.SetImportFlags2(TImportFlags2.if2IncrementalUpd);
         if (PDF.OpenImportFile(InFileName, TPwdType.ptOpen, null) < 0) return false;
         PDF.ImportPDFFile(1, 1.0, 1.0);

         if (VisibleSignature)
         {
            PDF.SetPageCoords(TPageCoord.pcTopDown);
            PDF.EditPage(1);
               int sig = PDF.CreateSigField(FieldName, -1, PosX, 30.0, 180.0, 40.0);
               PDF.SetFieldBorderWidth(sig, 0.0);
            PDF.EndPage();
         }
         if ((retval = PDF.CloseAndSignFile("../../../../test_files/test_cert.pfx", "123456", Reason, null)) == true)
         {
            if (outName == filePath)
            {
               File.Delete(OutFileName);
               File.Move(outName, OutFileName);
            }
         }
         return retval;
      }



		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            // We write the output file into the current directory.
            String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";

            // We sign the file 4 times in this example. We add two visible and two invisible signatures.
            if (SignFile(pdf, "../../../../../license.PDF", filePath, "Signature1", "Test signature 1", 50.0, true))
            {
               if (SignFile(pdf, filePath, filePath, "Signature2", "Test signature 2", 430.0, true))
               {
                  if (SignFile(pdf, filePath, filePath, null, "Test signature 3", 0.0, false))
                  {
                     if (SignFile(pdf, filePath, filePath, null, "Test signature 4", 0.0, false))
                     {
                        Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                        System.Diagnostics.Process p = new System.Diagnostics.Process();
                        p.StartInfo.FileName = filePath;
                        p.Start();
                     }
                  }
               }
            }
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
